﻿package 
{
	import flash.media.Sound;
	import flash.events.SampleDataEvent;
	
	/**
	 * ...
	 * @author Daniel Bienvenu
	 */
	public class Speaker 
	{
		private static var TIMEUNIT_WAVE:Number = 1.0 / 44100;
		
		private var mySound:Sound;
		
		private var float_offset:Number;
		
		private var previous_out:Number;
		
		private var snd:SoundChip;
		
		public function Speaker(sndchip:SoundChip) {
			snd = sndchip;
			float_offset = 0.0;
			previous_out = 0.0;
			
			mySound = new Sound(); 
			mySound.addEventListener(SampleDataEvent.SAMPLE_DATA, outputSoundGenerator); 
			mySound.play();
		}
		
		private function outputSoundGenerator(event:SampleDataEvent):void {
			var out:Number;
			for ( var c:int = 0; c < 2048; c++ ) { // 
				previous_out = snd.output() + previous_out / 5.0;
				out = previous_out + float_offset;
				float_offset += -out / 50.0;
				event.data.writeFloat(out); // LEFT CHANNEL
				event.data.writeFloat(out); // RIGHT CHANNEL
				snd.update(TIMEUNIT_WAVE);
			}
		}
		
	}
	
}